/******************************************************************************/
Game.ObjMap<Player            > Players; // container for player objects
Game.ObjMap<ObjTempParticles  > particles;
Game.ObjMap<StaticToggleable  > staticToggleables; // container for every static object that can be hidden/displayed
Game.ObjMap<Game.ObjLightCone > coneLights;
Game.ObjMap<Game.ObjLightPoint> pointLights;
Game.ObjMap<Item              > items;
Game.ObjMap<EventTrigger      > eventTriggers;
Game.ObjMap<SlidingDoor       > slidingDoors;
Game.ObjMap<Elevator          > elevators;
Game.ObjMap<ButtonObject      > buttonObjects;
Game.ObjMap<ToggleDoor        > eventToggleDoors;
Game.ObjMap<OpenDoor          > eventOpenDoors;
Game.ObjMap<ToggleTrigger     > eventToggleTriggers;
Game.ObjMap<ControlElevator   > eventControlElevators;
Game.ObjMap<PlaySound         > eventPlaySounds;
Game.ObjMap<StopSound         > eventStopSounds;
Game.ObjMap<ToggleDrawObjects > eventToggleDrawObjects;
Game.ObjMap<SpawnParticles    > eventDrawParticles;
Game.ObjMap<RemoveParticles   > eventRemoveParticles;
Game.ObjMap<SpawnLight        > eventSpawnLight;
Game.ObjMap<RemoveLight       > eventRemoveLights;
Game.ObjMap<DrawText          > eventDrawTexts;
Game.ObjMap<StopDrawText      > eventStopDrawTexts;
Game.ObjMap<ShakeCamera       > eventShakeCameras;
Game.ObjMap<TeleportObject    > eventTeleportObjects;
Game.ObjMap<EventGroup        > eventBehaviours;

// Variables
Game.ObjMap<VarBool      > variablesBool;
Game.ObjMap<VarInt       > variablesInt;
Game.ObjMap<VarFloat     > variablesFloat;
Game.ObjMap<VarVec       > variablesVec;
Game.ObjMap<VarString    > variablesString;
Game.ObjMap<VarPointLight> variablesPointLight;
Game.ObjMap<VarParticles > variablesParticles;
Game.ObjMap<VarAudio     > variablesAudio;
// Set variables
Game.ObjMap<SetBool      > eventSetBool;
Game.ObjMap<SetInt       > eventSetInt;
Game.ObjMap<SetFloat     > eventSetFloat;
Game.ObjMap<SetVec       > eventSetVec;
Game.ObjMap<SetString    > eventSetString;
Game.ObjMap<SetPointLight> eventSetPointLight;
// Check variables
Game.ObjMap<CheckBool> eventCheckBool;
Game.ObjMap<CheckInt > eventCheckInt;

GameCamera camera; // The main camera

/******************************************************************************/
void InitPre()
{
   LogConsole();
   LogShow(false, false, true, false); 
   
   EE_INIT();
   App.flag = APP_WORK_IN_BACKGROUND;
   Ms.hide();
   Ms.clip(null, 1);
   D.full(false).mode(1280, 800).sync(false);
   D.bumpMode(BUMP_PARALLAX).shadowSoft(1).shadowJitter(true).shadowMapSize(512).shadowMapNum(3);
   D.ambientMode(AMBIENT_MED); 
   D.volLight(true).volAdd(true).ambientPower(0);
   D.bloomOriginal(2).bloomScale(1);
   D.viewRange(100);
}
/******************************************************************************/
bool Init()
{
   Physics.create(EE_PHYSX_DLL_PATH);
   Physics.gravity(Vec(0, -20, 0));
   
   Game.World.activeRange(D.viewRange())
       .setObjType(Players               , OBJ_CHR)
       .setObjType(particles             , OBJ_PARTICLES)
       .setObjType(staticToggleables     , OBJ_HIDEABLE)
       .setObjType(coneLights            , OBJ_CONELIGHT)
       .setObjType(pointLights           , OBJ_POINTLIGHT) 
       .setObjType(items                 , OBJ_ITEM)   
       .setObjType(eventTriggers         , OBJ_EVENTTRIGGER)
       .setObjType(slidingDoors          , OBJ_SLIDINGDOOR)
       .setObjType(elevators             , OBJ_ELEVATOR)
       .setObjType(buttonObjects         , OBJ_BUTTON)
       .setObjType(eventToggleDoors      , OBJ_TOGGLEDOOR)
       .setObjType(eventOpenDoors        , OBJ_OPENDOOR)
       .setObjType(eventToggleTriggers   , OBJ_TOGGLETRIGGER)
       .setObjType(eventControlElevators , OBJ_CONTROLELEVATOR)
       .setObjType(eventPlaySounds       , OBJ_PLAYSOUND)
       .setObjType(eventStopSounds       , OBJ_STOPSOUND)
       .setObjType(eventToggleDrawObjects, OBJ_TOGGLEDRAWOBJECTS)
       .setObjType(eventSpawnLight       , OBJ_SPAWNLIGHT)
       .setObjType(eventRemoveLights     , OBJ_REMOVELIGHT)
       .setObjType(eventDrawParticles    , OBJ_SPAWNPARTICLES)
       .setObjType(eventRemoveParticles  , OBJ_REMOVEPARTICLES)
       .setObjType(eventDrawTexts        , OBJ_DRAWTEXT)
       .setObjType(eventStopDrawTexts    , OBJ_STOPDRAWTEXT)
       .setObjType(eventShakeCameras     , OBJ_SHAKECAMERA)
       .setObjType(eventTeleportObjects  , OBJ_TELEPORTOBJECT)
       .setObjType(eventBehaviours       , OBJ_EVENTGROUP)
       // Variables
       .setObjType(variablesBool         , OBJ_BOOL)
       .setObjType(variablesInt          , OBJ_INT)
       .setObjType(variablesFloat        , OBJ_FLOAT)
       .setObjType(variablesVec          , OBJ_VEC)
       .setObjType(variablesString       , OBJ_STRING)
       .setObjType(variablesPointLight   , OBJ_VARPOINTLIGHT)
       .setObjType(variablesParticles    , OBJ_VARPARTICLES)
       .setObjType(variablesAudio        , OBJ_AUDIO)
       // Set variables
       .setObjType(eventSetBool          , OBJ_SETBOOL)
       .setObjType(eventSetInt           , OBJ_SETINT)
       .setObjType(eventSetFloat         , OBJ_SETFLOAT)
       .setObjType(eventSetVec           , OBJ_SETVEC)
       .setObjType(eventSetString        , OBJ_SETSTRING)
       .setObjType(eventSetPointLight    , OBJ_SETPOINTLIGHT)
       .setObjType(eventCheckBool        , OBJ_CHECKBOOL)
       .setObjType(eventCheckInt         , OBJ_CHECKINT); 
   Game.World.New(UID(2162960215, 1166629077, 880822961, 2503136980));
   //Game.World.New(UID(3390242177, 1076055591, 2011450805, 3634839263));
   if(Game.World.settings().environment) Game.World.settings().environment->set();  
   

   return true;
}
/******************************************************************************/
void Shut()
{
   LogConsole(false);
}
/******************************************************************************/
bool Update()
{
   if(Kb.bp(KB_ESC)) return false;
   
   Game.World.update(Cam.at); // Update world to given position
  
   camera.Update();
   
   return true;
}
/******************************************************************************/
void Render()
{
   Game.World.draw();
}
void Draw()
{
   Renderer(Render);
   
   // Draw the FPS 
   TextStyle ts;
   ts.color = GREY;
   D.text(ts, 1.3, 0.9, S + (int)Time.fps()); 
}
/******************************************************************************/